<?php
##======================================================##
##  365 FAQ                                             ##
##  Copyright (C) php365.com All rights reserved.       ##
##  http://php365.com/                                  ##
##======================================================##
// デフォルト設定ライブラリ
require_once("./lib/config.php");
// データベース操作ライブラリ
require_once(PATH_LIB.DBSTR.".php");
// 共通仕様サブルーチン
require_once(PATH_LIB."common.php");
#--------------------------------------------------------#

switch($_SERVER['REQUEST_METHOD']):
	case 'GET':
		if(!isset($_GET['mode'])){	show_html_top();exit; }
		switch($_GET['mode']):
			case 'ct':
				show_html_category();
				break;
			case 'tag':
				show_html_tag();
				break;
			case 'faq':
				show_html_faq();
				break;
			case 'ct_all':
				show_ct_all();
				break;
			case 'tag_all':
				show_tag_all();
				break;
			case 'faq_all':
				show_faq_all();
				break;
			case 'login':
				show_login();
				break;
			default:
				show_html_top();
				break;
		endswitch;
		break;
	case 'POST':
		if(!isset($_POST['mode'])){	show_html_top();exit; }
		switch($_POST['mode']):
			case 'login':
				login();
				break;
			default:
				show_html_top();
				break;
		endswitch;
		break;
	default:
		show_html_top();
		break;
endswitch;
exit;
#------------------#
#  全カテゴリ表示  #
#------------------#
function show_ct_all(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリリスト取得
	$list_top_category = get_list_top_category($db,"",$config_arr['show_ct']);

	// タグリスト取得
	$list_tags = get_list_tags($db,$config_arr['tag_num'],$config_arr['order_tag']);

	// カテゴリ一覧取得
	$list_faqs = get_list_category_all($db,$config_arr['show_ct']);

	$db->close();

	$pages_str = "";
	$theme = "カテゴリ一覧";
	require(PATH_TEMPLATE."top.html");
}
#--------------------#
#  全タグリスト表示  #
#--------------------#
function show_tag_all(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリリスト取得
	$list_top_category = get_list_top_category($db,"",$config_arr['show_ct']);

	// タグリスト取得
	$list_tags = get_list_tags($db,$config_arr['tag_num'],$config_arr['order_tag']);

	// タグ一覧取得
	$list_faqs = get_list_tags_all($db);

	$db->close();

	$pages_str = "";
	$theme = "タグ一覧";
	require(PATH_TEMPLATE."top.html");
}
#-------------#
#  全FAQ表示  #
#-------------#
function show_faq_all(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリリスト取得
	$list_top_category = get_list_top_category($db,"",$config_arr['show_ct']);

	// タグリスト取得
	$list_tags = get_list_tags($db,$config_arr['tag_num'],$config_arr['order_tag']);

	if(isset($_GET['p']) && intval($_GET['p']) > 0){
		$pagenow = intval($_GET['p']);
	}else{
		$pagenow = 1;
	}
	$num_start = ($pagenow - 1) * $config_arr['pageview'] + 1;
	$offset = $num_start - 1;

	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE status = 1";
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows_all < $pagenow * $config_arr['pageview']){
		$num_end = $rows_all;
	}else{
		$num_end = $pagenow * $config_arr['pageview'];
	}
	foreach(array('rows_all', 'num_start', 'num_end') as $key){
		$key_new = $key . "_format";
		$$key_new = str_replace(",", "&#44;", number_format($$key));
	}

	// FAQリスト取得
	$list_faqs = get_list_faqs($db,$offset,$config_arr['faq_num'],$config_arr['click'],$_GET['mode'],$config_arr['show'],$config_arr['order']);

	$argv = t2h($_SERVER['SCRIPT_NAME'])."?mode=faq_all";
	$pageing = $num_start_format."&nbsp;-&nbsp;".$num_end_format."&nbsp;(&nbsp;".$rows_all_format."&nbsp;件中&nbsp;)<br><br>\n";
	$pages_str = get_control_pages($rows_all,$pagenow,$num_start,$num_end,"seek",$argv,$pageing,$config_arr['pageview'],$config_arr['page_control']);
	$db->close();

	$theme = "よくある質問";
	require(PATH_TEMPLATE."top.html");
}
#------------------#
#  タグリスト表示  #
#------------------#
function show_html_tag(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリ一覧取得
	$list_top_category = get_list_top_category($db,"",$config_arr['show_ct']);

	// タグリスト取得
	$list_tags = get_list_tags($db,$config_arr['tag_num'],$config_arr['order_tag']);

	if(isset($_GET['p']) && intval($_GET['p']) > 0){
		$pagenow = intval($_GET['p']);
	}else{
		$pagenow = 1;
	}
	$num_start = ($pagenow - 1) * $config_arr['pageview'] + 1;
	$offset = $num_start - 1;

	$tag = check_keyword($_GET['tag']);

	// タグ詳細
	$cnt = 0;
	$faq_detail = "";
	$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE tag = '".$db->escape_string($tag)."' and status = 1";
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows_all == 0){	error("タグ：".t2h($tag)."を設定したFAQはありません、LINE=".__LINE__); }
	$sql = "SELECT id FROM ".DBPREFIX."tags WHERE tag = '".$db->escape_string($tag)."' and status = 1 ORDER BY no";
	$sort = intval($config_arr['order']) < 1 ? "" : " DESC";
	$sql = $sql . $sort . " limit ${offset}, ".$config_arr['pageview'];
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		$sql = "SELECT id,question,answer,status FROM ".DBPREFIX."master WHERE id = ${item['id']}";
		$item_master = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($item_master['status'] == 0){	continue; }
		$faq_detail .= "<a name=\"${item_master['id']}\"></a>\n";
		$faq_detail .= "<dt>Q.<strong>${item_master['question']}</strong></dt>\n";
		$faq_detail .= "<dd>A.${item_master['answer']}\n";
		$sql = "SELECT tag FROM ".DBPREFIX."tags WHERE id = ${item['id']} ORDER BY id";
		$items_tags = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		foreach($items_tags as $item_tags){
			if(empty($item_tags['tag'])){	continue; }
			$cnt++;
			if($cnt == 1){	$faq_detail .= "<br><br>関連タグ：\n"; }
			$faq_detail .= "<a href=\"".t2h($_SERVER['SCRIPT_NAME'])."?mode=tag&tag=".rawurlencode($item_tags['tag'])."\">".t2h($item_tags['tag'])."</a>&nbsp;\n";
		}
		$faq_detail .= "</dd>\n";
	}
	if(!empty($faq_detail)){	"<dl>\n" . $faq_detail . "</dl>\n"; }

	if($rows_all < $pagenow * $config_arr['pageview']){
		$num_end = $rows_all;
	}else{
		$num_end = $pagenow * $config_arr['pageview'];
	}
	foreach(array('rows_all', 'num_start', 'num_end') as $key){
		$key_new = $key . "_format";
		$$key_new = str_replace(",", "&#44;", number_format($$key));
	}

	$argv = t2h($_SERVER['SCRIPT_NAME'])."?mode=tag&tag=${_GET['tag']}";
	$pageing = $num_start_format."&nbsp;-&nbsp;".$num_end_format."&nbsp;(&nbsp;".$rows_all_format."&nbsp;件中&nbsp;)<br><br>\n";
	$pages_str = get_control_pages($rows_all,$pagenow,$num_start,$num_end,"seek",$argv,$pageing,$config_arr['pageview'],$config_arr['page_control']);

	$db->close();
	require(PATH_TEMPLATE."tag_to_faq.html");
}
#-----------#
#  FAQ表示  #
#-----------#
function show_html_faq(){
	global $CNF,$ct_name;

	$_GET['id'] = intval($_GET['id']);
	if(!isset($_GET['id']) || $_GET['id'] < 1){	error("FAQ番号:".t2h($_GET['id'])."が不正なです、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリ一覧取得
	$list_top_category = get_list_top_category($db,"",$config_arr['show_ct']);

	// タグリスト取得
	$list_tags = get_list_tags($db,$config_arr['tag_num'],$config_arr['order_tag']);

	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE id = ${_GET['id']}";
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows_all == 0){	error("FAQ番号：".t2h($_GET['id'])."は存在しません、LINE=".__LINE__); }
if($config_arr['show'] == 0){
	$sql = "SELECT id,question,answer,status FROM ".DBPREFIX."master WHERE id = ${_GET['id']}";
	$item_master = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if(intval($item_master['status']) == 0){	error("FAQ番号：".t2h($_GET['id'])."は非公開です、LINE=".__LINE__); }
	$question = $item_master['question'];
	$faq_detail = "<a name=\"${item_master['id']}\"></a>\n";
	$faq_detail .= "<dt>Q.<strong>${item_master['question']}</strong></dt>\n";
	$faq_detail .= "<dd>A.${item_master['answer']}\n";
	$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE id = ${_GET['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows > 0){
	$sql = "SELECT tag FROM ".DBPREFIX."tags WHERE id = ${_GET['id']} ORDER BY id";
	$items_tags = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	$cnt = 0;
	foreach($items_tags as $item_tags){
		if(empty($item_tags['tag'])){	continue; }
		$cnt++;
		if($cnt == 1){	$faq_detail .= "<br><br>関連タグ：\n"; }
		$faq_detail .= "<a href=\"".t2h($_SERVER['SCRIPT_NAME'])."?mode=tag&tag=".rawurlencode($item_tags['tag'])."\">".t2h($item_tags['tag'])."</a>&nbsp;\n";
	}
	}
	$faq_detail .= "</dd>\n";
	$pages_str = "";
}else{
	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE id = ${_GET['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("FAQ番号：".t2h($_GET['id'])."は存在しません、LINE=".__LINE__); }
	$sql = "SELECT ct_cd,status FROM ".DBPREFIX."master WHERE id = ${_GET['id']}";
	$item_master = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if(intval($item_master['status']) == 0){	error("FAQ番号：".t2h($_GET['id'])."は存在しません、LINE=".__LINE__); }
	if(!preg_match('/^[0-9]{6}$/', $item_master['ct_cd'])){	error("カテゴリ番号が不正です、LINE=".__LINE__); }
	if(intval($config_arr['show_ct']) == 1){
		$str2_4 = substr($item_master['ct_cd'], 2, 4);
		$str4_2 = substr($item_master['ct_cd'], 4, 2);
		if(intval($str2_4) == 0){
			$ct_target = substr($item_master['ct_cd'], 0, 2)."%00";
		}elseif(intval($str4_2) == 0){
			$ct_target = substr($item_master['ct_cd'], 0, 4)."%";
		}else{
			$ct_target = $item_master['ct_cd'];
		}
		$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd like '${ct_target}' AND status = 1";
	}else{
		$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${item_master['ct_cd']}' AND status = 1";
	}
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);

	$sql = str_replace("count(*)", "id,question", $sql);
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	$cnt = 0;
	$flag = false;
	$question = "";
	foreach($items as $item){
		$cnt++;
		if($item['id'] == $_GET['id']){
			$flag = true;
			$question = $item['question'];
			break;
		}
	}
	if(!$flag){	error("FAQ番号：".t2h($_GET['id'])."は存在しません、LINE=".__LINE__); }
	$sql = str_replace("SELECT id", "SELECT *", $sql);

	$pagenow = ceil($cnt / $config_arr['pageview']);
	$num_start = ($pagenow - 1) * $config_arr['pageview'] + 1;
	$offset = $num_start - 1;
	if($rows_all < $pagenow * $config_arr['pageview']){
		$num_end = $rows_all;
	}else{
		$num_end = $pagenow * $config_arr['pageview'];
	}
	foreach(array('rows_all', 'num_start', 'num_end') as $key){
		$key_new = $key . "_format";
		$$key_new = str_replace(",", "&#44;", number_format($$key));
	}

	$argv = t2h($_SERVER['SCRIPT_NAME'])."?mode=ct&ct=${item_master['ct_cd']}";
	$pageing = $num_start_format."&nbsp;-&nbsp;".$num_end_format."&nbsp;(&nbsp;".$rows_all_format."&nbsp;件中&nbsp;)<br><br>\n";
	$pages_str = get_control_pages($rows_all,$pagenow,$num_start,$num_end,"seek",$argv,$pageing,$config_arr['pageview'],$config_arr['page_control']);
	
	// FAQ詳細リスト取得
	$faq_detail = get_list_detail($db,$sql,"",$offset,$config_arr['pageview'],$_GET['id']);
}

	$db->close();
	require(PATH_TEMPLATE."faq.html");
}
#--------------------#
#  トップページ表示  #
#--------------------#
function show_html_top(){
	global $CNF,$CATEGORY,$ct_name;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリ階層リンク取得
	$list_top_category = get_list_top_category($db,"",$config_arr['show_ct']);

	// タグリスト取得
	$list_tags = get_list_tags($db,$config_arr['tag_num'],$config_arr['order_tag']);

	// FAQリスト取得
	$list_faqs = get_list_faqs($db,0,$config_arr['faq_num'],$config_arr['click'],"",$config_arr['show'],$config_arr['order']);

	$db->close();

	$pages_str = "";
	$theme = "よくある質問";
	require(PATH_TEMPLATE."top.html");
}
#----------------------#
#  カテゴリページ表示  #
#----------------------#
function show_html_category(){
	global $CNF;

	if(!preg_match('/^[0-9]{6}$/', $_GET['ct'])){	error("カテゴリIDが不正なです、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリ名取得
	$ct_name = get_name_category($db,$_GET['ct']);

	// カテゴリ階層リンク取得
	$list_navi_category = get_navi_category($db,$_GET['ct']);

	// カテゴリ一覧取得
	$list_top_category = get_list_top_category($db,$_GET['ct'],$config_arr['show_ct']);

	// サブカテゴリ一覧取得
	$list_sub_categories = get_list_sub_categories($db,$_GET['ct'],$config_arr['show_ct']);

	// タグリスト取得
	$list_tags = get_list_tags($db,$config_arr['tag_num'],$config_arr['order_tag']);

	if(intval($config_arr['show_ct']) == 1){
		$str2_4 = substr($_GET['ct'], 2, 4);
		$str4_2 = substr($_GET['ct'], 4, 2);
		if(intval($str2_4) == 0){
			$ct_target = substr($_GET['ct'], 0, 2)."%";
		}elseif(intval($str4_2) == 0){
			$ct_target = substr($_GET['ct'], 0, 4)."%";
		}else{
			$ct_target = $_GET['ct'];
		}
		$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd like '${ct_target}' AND status = 1";
	}else{
		$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${_GET['ct']}' AND status = 1";
	}
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);

	if(isset($_GET['p']) && intval($_GET['p']) > 0){
		$pagenow = intval($_GET['p']);
	}else{
		$pagenow = 1;
	}
	$num_start = ($pagenow - 1) * $config_arr['pageview'] + 1;
	$offset = $num_start - 1;
	if($rows_all < $pagenow * $config_arr['pageview']){
		$num_end = $rows_all;
	}else{
		$num_end = $pagenow * $config_arr['pageview'];
	}
	foreach(array('rows_all', 'num_start', 'num_end') as $key){
		$key_new = $key . "_format";
		$$key_new = str_replace(",", "&#44;", number_format($$key));
	}

	$argv = t2h($_SERVER['SCRIPT_NAME'])."?mode=ct&ct=${_GET['ct']}";
	$pageing = $num_start_format."&nbsp;-&nbsp;".$num_end_format."&nbsp;(&nbsp;".$rows_all_format."&nbsp;件中&nbsp;)<br><br>\n";
	$pages_str = get_control_pages($rows_all,$pagenow,$num_start,$num_end,"seek",$argv,$pageing,$config_arr['pageview'],$config_arr['page_control']);
	
	// FAQ詳細リスト取得
	if($rows_all > 0){
		$list_detail = get_list_detail($db,$sql,"",$offset,$config_arr['pageview']);
	}else{
		$list_detail = "";
	}

	$db->close();
	require(PATH_TEMPLATE."ct.html");
}
#--------------------------#
#  カテゴリ階層リンク取得  #
#--------------------------#
function get_navi_category(&$db,$ct_cd){

	$str = "";
	if(!preg_match('/^[0-9]{6}$/', $ct_cd)){	return $str; }
	$str2_4 = substr($ct_cd, 2, 4);
	$str4_2 = substr($ct_cd, 4, 2);
	if(intval($str2_4) == 0){
		$ct_target = substr($ct_cd, 0, 2)."0000";
		$str .= "&nbsp;&gt;&nbsp;" . t2h(get_name_category($db,$ct_target));
	}elseif(intval($str4_2) == 0){
		$ct_target = substr($ct_cd, 0, 2)."0000";
		$str .= "&nbsp;&gt;&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${ct_target}\">".t2h(get_name_category($db,$ct_target)).'</a>';
		$ct_target = substr($ct_cd, 0, 4)."00";
		$str .= "&nbsp;&gt;&nbsp;" . t2h(get_name_category($db,$ct_target));
	}else{
		$ct_target = substr($ct_cd, 0, 2)."0000";
		$str .= "&nbsp;&gt;&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${ct_target}\">".t2h(get_name_category($db,$ct_target)).'</a>';
		$ct_target = substr($ct_cd, 0, 4)."00";
		$str .= "&nbsp;&gt;&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${ct_target}\">".t2h(get_name_category($db,$ct_target)).'</a>';
		$str .= "&nbsp;&gt;&nbsp;" . t2h(get_name_category($db,$ct_cd));
	}
	return $str;
}
#------------------------#
#  サブカテゴリ一覧取得  #
#------------------------#
function get_list_sub_categories(&$db,$ct_cd,$show_ct=1){
	global $CNF,$ct_name;

	$str = "";
	$str2_4 = substr($ct_cd, 2, 4);
	$str4_2 = substr($ct_cd, 4, 2);
	if(intval($str2_4) == 0){
		$ct_target = substr($ct_cd, 0, 2)."%00";
		$ct_key = substr($ct_cd, 0, 2)."%";
	}elseif(intval($str4_2) == 0){
		$ct_target = substr($ct_cd, 0, 4)."%";
		$ct_key = substr($ct_cd, 0, 4)."%";
	}else{
		return $str;
	}
	$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${ct_cd}'";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	return $str; }
	if($show_ct == 1){
		$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd like '${ct_key}' AND status = 1";
		$rows_faq = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	}else{
		$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${ct_cd}' AND status = 1";
		$rows_faq = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	}
	if(preg_match('/[0]{4}$/', $ct_cd)){
		$ct_name_now = $ct_name;
	}else{
		$ct_name_now = get_name_category($db,$ct_cd);
	}
	$str .= <<<EOM
<table border="0" width="100%" cellspacing="1" cellpadding="5">
<tr>
<td bgcolor="#FFFFFF" width="100" align="left">
EOM;
	$str .= "・<a href=\"${CNF['main']}?mode=ct&ct=${ct_cd}\">" . t2h($ct_name_now) . "</a>&nbsp;(" . number_format($rows_faq) . ")<br>";
	$sql = "SELECT * FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${ct_cd}' ORDER BY ct_cd";
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	$cnt = 0;
	foreach($items as $item){
		$str2_4 = substr($item['ct_cd'], 2, 4);
		$str4_2 = substr($item['ct_cd'], 4, 2);
		if(intval($str2_4) == 0){
			$ct_target = substr($item['ct_cd'], 0, 2)."%00";
		}elseif(intval($str4_2) == 0){
			$ct_target = substr($item['ct_cd'], 0, 4)."%";
		}else{
			$ct_target = $item['ct_cd'];
		}
		if($show_ct == 1){
			$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd like '${ct_target}' AND status = 1";
			$rows_sub = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		}else{
			$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${item['ct_cd']}' AND status = 1";
			$rows_sub = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		}
		$cnt++;
		if($cnt < $rows){
			$str .= "&nbsp;├&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${item['ct_cd']}\">" . t2h($item['ct_name']) . "</a>&nbsp;(".number_format($rows_sub).")<br>";
		}elseif($cnt == $rows){
			$str .= "&nbsp;└&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${item['ct_cd']}\">" . t2h($item['ct_name']) . "</a>&nbsp;(".number_format($rows_sub).")<br>";
		}
	}
	if(!empty($str)){
		$str .= <<<EOM
</td></tr></table>\n
EOM;
	}
	return $str;
}
#---------------------#
#  FAQ詳細リスト取得  #
#---------------------#
function get_list_detail(&$db,$sql,$order="",$offset="",$pageview="",$id=0){
	global $CNF;

	$str = "";
	$sort = intval($order) < 1 ? "" : " DESC";

	$sql = str_replace("count(*)", "*", $sql);
	$sql = $sql . " ORDER BY id ".$sort;
	$sql .= " limit ${offset}, ".$pageview;
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		$str .= "<a name=\"${item['id']}\"></a>\n";
		if($id > 0 && $item['id'] == $id){
			$str .= "<dt class=\"focus\">Q.<strong>${item['question']}</strong></dt>\n";
			$str .= "<dd class=\"focus\">A.${item['answer']}\n";
		}else{
			$str .= "<dt>Q.<strong>${item['question']}</strong></dt>\n";
			$str .= "<dd>A.${item['answer']}\n";
		}
		$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE id = ${item['id']}";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows > 0){
		$sql = "SELECT tag FROM ".DBPREFIX."tags WHERE id = ${item['id']} ORDER BY id";
		$items_tags = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		$cnt = 0;
		foreach($items_tags as $item_tags){
			if(empty($item_tags['tag'])){	continue; }
			$cnt++;
			if($cnt == 1){	$str .= "<br><br>関連タグ：\n"; }
			$str .= "<a href=\"".t2h($_SERVER['SCRIPT_NAME'])."?mode=tag&tag=".rawurlencode($item_tags['tag'])."\">".t2h($item_tags['tag'])."</a>&nbsp;\n";
		}
		}
		$str .= "</dd>\n";
		//$str .= "<div align=\"right\"><a href=\"#top\"><font size=\"-1\">▲上へ</a></font></div>\n";
	}
	if(!empty($str)){	"<dl>\n" . $str . "</dl>\n"; }

	return $str;
}
#----------------------#
#  ログイン画面        #
#----------------------#
function show_login(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	$db->close();

	require(PATH_TEMPLATE."login.html");
}
#------------------------------#
#  タグ（キーワード）チェック  #
#------------------------------#
function check_keyword($str){

	$str = rawurldecode($str);
	$str = trim($str);
	if(get_magic_quotes_gpc()){	$str = stripslashes($str); }
	$str = strip_tags($str);
	$str = preg_replace('/[\n\r\t\0]/', '', $str);
	$str = mb_ereg_replace("(\s|　)+", " ", $str);
	$str = preg_replace('/style[^=]*=/i', '', $str);
	$str = preg_replace('/on(Blur|Change|Click|Focus|Load|Mouse|Select|Submit|Reset|Unload)[^=]*=/i', '', $str);
	$str = htmlspecialchars($str);
	$str = str_replace(",", "&#44;", $str);
	$str = str_replace("&amp;", "&", $str);

	return $str;
}
